package coreservlets.listeners;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

/** Proces nasuchujcy, ktry odczytuje nazw firmy
 *  w momencie adowania aplikacji po raz pierwszy. Nazwa
 *  jest zapisywana w atrybucie companyName kontekstu serwletu.
 *  Z tak zapisanej nazwy korzysta bd rnorodne
 *  serwlety i strony JSP.
 *  <P>
 *  Proces odczytuje rwnie poprzedni nazw firmy
 *  i zapisuje j w atrybucie formerCompanyName.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class InitialCompanyNameListener
    implements ServletContextListener {
  private static final String DEFAULT_NAME =
    "MISSING-COMPANY-NAME";

  /** Odczytanie parametrw inicjalizacyjnych companyName i formerCompanyName
   *  oraz umieszczenie ich w kontekcie serwletu.
   */
  public void contextInitialized(ServletContextEvent event) {
    ServletContext context = event.getServletContext();
    setInitialAttribute(context,
                        "companyName",
                        DEFAULT_NAME);
    setInitialAttribute(context,
                        "formerCompanyName",
                        "");
  }

  public void contextDestroyed(ServletContextEvent event) {}

   /** Odczytanie parametru inicjalizujcego kontekstu serwletu
    *  o wskazanej nazwie. Jeli parametr zostanie znaleziony, jego warto
    *  jest zapisywana w atrybucie kontekstu serwletu o tej samej nazwie.
    *  Jeli parametr inicjalizacyjny nie bdzie istnia, w atrybucie
    *  kontekstu serwletu umieszczona zostanie warto domylna.
    */
  private void setInitialAttribute(ServletContext context,
                                   String initParamName,
                                   String defaultValue) {
    String initialValue =
      context.getInitParameter(initParamName);
    if (initialValue != null) {
      context.setAttribute(initParamName, initialValue);
    } else {
      context.setAttribute(initParamName, defaultValue);
    }
  }
  
  /** Metoda statyczna, ktra zwraca atrybut kontekstu serwletu
   *  o nazwie "companyName", jeeli jest on dostpny.
   *  Jeeli atrybut jest niedostpny, metoda zwraca
   *  warto domyln.
   */
  public static String getCompanyName(ServletContext context) {
    String name =
      (String)context.getAttribute("companyName");
    if (name == null) {
      name = DEFAULT_NAME;
    }
    return(name);
  }
  
  /** Metoda statyczna, ktra zwraca atrybut kontekstu serwletu
   *  o nazwie "formerCompanyName", jeeli jest on dostpny.
   *  Jeeli atrybut jest niedostpny, metoda zwraca
   *  warto domyln.
   */
  public static String getFormerCompanyName
                                     (ServletContext context) {
    String name =
      (String)context.getAttribute("formerCompanyName");
    if (name == null) {
      name = "";
    }
    return(name);
  }
}
